package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bEmpresas;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bEmpresasBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaEmpresasExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoTiposEmpresa.xls";
		InputStream inputStream = W83bTablaEmpresasExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaEmpresas = (ArrayList)contexto.get("w83bListaEmpresas");
        W83bEmpresasBean empresaBean = (W83bEmpresasBean)contexto.get("w83bEmpresasTempBean");     
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);     

        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);     
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);     
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));     
        HashMap mapaEmpresas=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);     
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1     
        HSSFCell cell = row.createCell((short)3);     
        row = sheet.getRow((short)4);     
        cell = row.getCell((short)2);     
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaEmpresas.get("tituloDepEs");     
        StringBuffer tituloImagenEu =  (StringBuffer)mapaEmpresas.get("tituloDepEu");     
        cell.setCellValue(tituloImagenEu.toString());     
        
        cell = row.getCell((short)6);     
        cell.setCellValue(tituloImagenEs.toString());     
        
        tituloImagenEs = (StringBuffer)mapaEmpresas.get("tituloDelelegacionEs");     
        tituloImagenEu = (StringBuffer)mapaEmpresas.get("tituloDelelegacionEu");     

        row = sheet.getRow((short)6);      
        cell = row.getCell((short)2);     
        cell.setCellValue(tituloImagenEu.toString());     
        
        cell = row.getCell((short)6);     
        cell.setCellValue(tituloImagenEs.toString());     
        
        row = sheet.getRow((short)9);     
        cell = row.getCell((short)0);     
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.empresas.listadoEmpresas").toUpperCase());     
        //MAPEO FORMULARIO
        row = sheet.getRow(Short.parseShort("12")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.empresas.codEmpresas"));
        cell = row.createCell(Short.parseShort("3"));
        if(!StringUtils.isEmpty(empresaBean.getCodEmpresas())){
        	cell.setCellValue(W83bUtilidades.numero(empresaBean.getCodEmpresas().toUpperCase()));
        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.baja"));
        cell = row.createCell(Short.parseShort("9"));
        if(StringUtils.isEmpty(empresaBean.getBaja())||W83bClsConstantes.ALTA.equals(empresaBean.getBaja())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());
        	
        }else{
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());
  	        	
        }
        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
        
        row = sheet.getRow(Short.parseShort("13")); 
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.empresas.descEmpresa"));
        cell = row.createCell(Short.parseShort("3"));
        if(!StringUtils.isEmpty(empresaBean.getDescEmpresas())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("3"),W83bClsConstantes.TRECE,Short.parseShort("5")));//NOPMD
	        cell.setCellValue(empresaBean.getDescEmpresas().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
        cell = row.getCell(Short.parseShort("6"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.empresas.descEmpresaEusk"));
        cell = row.createCell(Short.parseShort("9"));
        if(!StringUtils.isEmpty(empresaBean.getDescEmpresasEusk())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("9"),W83bClsConstantes.TRECE,Short.parseShort("11")));//NOPMD
	        cell.setCellValue(empresaBean.getDescEmpresasEusk().toUpperCase());
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
        }else{
        	cell.setCellValue("");
        }
        
    	 if((empresaBean.getDescEmpresas()).length()>=(empresaBean.getDescEmpresasEusk()).length()){
 	        if(38<empresaBean.getDescEmpresas().length()){
 	    		row.setHeightInPoints((short)(18*((empresaBean.getDescEmpresas()).length()/38)+1));
 	    	}
         }else{
         	 if(42<empresaBean.getDescEmpresasEusk().length()){
          		row.setHeightInPoints((short)(18*((empresaBean.getDescEmpresasEusk()).length()/42)+1));
          	}
         }  
        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("16")); // Creacin de la fila 1
        cell = row.getCell(Short.parseShort("0")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.empresas.codEmpresas"));
        
        cell = row.getCell(Short.parseShort("1")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.empresas.descEmpresa"));
        
        cell = row.getCell(Short.parseShort("6")); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.empresas.descEmpresaEusk"));
        
        for(int i=0;i<listaEmpresas.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECISIETE+i); // Creacin de la fila 1//NOPMD
        	
        	//Cod Tipo Empresa
        	cell = row.createCell(Short.parseShort("0"));
        	if(StringUtils.isNotEmpty(((W83bEmpresasBean)listaEmpresas.get(i)).getCodEmpresas())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bEmpresasBean)listaEmpresas.get(i)).getCodEmpresas()));
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	
        	//Descripcin Tipo Empresa
        	
        	cell = row.createCell(Short.parseShort("1"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("1"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("5")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresas())){
        		cell.setCellValue(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresas());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("2")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("4")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("5")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	//Descripcin Tipo Empresa Euskera
        	cell = row.createCell(Short.parseShort("6"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISIETE+i,Short.parseShort("6"),W83bClsConstantes.DIECISIETE+i,Short.parseShort("11")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresasEusk())){
        		cell.setCellValue(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresasEusk());
        	}else{
        		cell.setCellValue("");
        	}
        	
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("7")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("9")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("10")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("11")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	
        	if(StringUtils.isNotEmpty(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresas()) 
        			&& StringUtils.isNotEmpty(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresasEusk())){
	        	if((((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresas()).length()>=(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresasEusk()).length()){
		        	if(85<(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresas()).length()){
		        		row.setHeightInPoints((short)(18*((((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresas()).length()/85)+1));
		        	}
		        }else{
		        	if(83<(((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresasEusk()).length()){
		        		row.setHeightInPoints((short)(18*((((W83bEmpresasBean)listaEmpresas.get(i)).getDescEmpresasEusk()).length()/83)+1));
		        	}
		        }
        	}
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoEmpresas.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}

	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
	
}
